package com.hero.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.MultipowerDialog;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class PowersPanel extends AbilityPanel {

	private static final long serialVersionUID = 189480006160974586L;

	private JMenuItem elementalControlMI;

	private JMenuItem multipowerMI;

	private JMenu powerFrameworksMenu;

	private JMenuItem vppMI;

	public PowersPanel() {
		super();
	}

	protected void checkIndices() {
		selectionList.checkIndices();
	}

	@Override
	protected GenericObjectList createSelectionList() {
		return new PowersList();
	}

	@Override
	protected String getAvailableLabel() {
		return "Powers";
	}

	@Override
	protected ArrayList<GenericObject> getAvailableObjects() {
		return HeroDesigner.getActiveTemplate().getPowers();
	}

	@Override
	protected ArrayList<GenericObject> getAvailablePrefabs() {
		return HeroDesigner.getInstance().getPrefabPowers();
	}

	@Override
	protected ArrayList<GenericObject> getObjects() {
		return HeroDesigner.getActiveHero().getPowers();
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		multipowerMI.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				com.hero.objects.Multipower list = new com.hero.objects.Multipower(
						"Multipower");
				MultipowerDialog dialog = new MultipowerDialog(list, true);
				dialog.setLocationRelativeTo(PowersPanel.this);
				dialog.setVisible(true);
				if (dialog.okButtonClicked) {
					selectionList.addObject(list);
				}
			}
		});
		elementalControlMI.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				com.hero.objects.ElementalControl list = new com.hero.objects.ElementalControl(
						"Elemental Control");
				GenericDialog dialog = list.getDialog(true, true);
				dialog.setLocationRelativeTo(PowersPanel.this);
				dialog.setVisible(true);
				if (dialog.okButtonClicked) {
					selectionList.addObject(list);
				}
			}
		});
		vppMI.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				com.hero.objects.VariablePowerPool list = new com.hero.objects.VariablePowerPool(
						"Variable Power Pool");
				GenericDialog dialog = list.getDialog(true, true);
				dialog.setLocationRelativeTo(PowersPanel.this);
				dialog.setVisible(true);
				if (dialog.okButtonClicked) {
					selectionList.addObject(list);
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		powerFrameworksMenu = new JMenu("Power Frameworks");

		// initialize power frameworks...
		multipowerMI = new JMenuItem("New Multipower...");
		elementalControlMI = new JMenuItem("New Elemental Control...");
		vppMI = new JMenuItem("New Variable Power Pool...");
		powerFrameworksMenu.add(multipowerMI);
		powerFrameworksMenu.add(elementalControlMI);
		powerFrameworksMenu.add(vppMI);
		menuBar.add(powerFrameworksMenu);
	}

	@Override
	protected boolean isEquipment() {
		return false;
	}

	@Override
	protected boolean isPower() {
		return true;
	}

	@Override
	public void reset() {
		selectionList.setData(HeroDesigner.getActiveHero().getPowers());
		availableList.setAvailableList(HeroDesigner.getActiveTemplate()
				.getPowers());
		if (!HeroDesigner.getActiveTemplate().is6E()) {
			elementalControlMI.setVisible(true);
		}
		if (HeroDesigner.getInstance().getPrefs().getSources().contains(
				"Hero System Fifth Edition Rule Book")
				|| HeroDesigner.getInstance().getPrefs().getSources().contains(
						"Sidekick")) {
			multipowerMI.setVisible(true);
			elementalControlMI.setVisible(true);
			powerFrameworksMenu.setVisible(true);
		} else {
			multipowerMI.setVisible(false);
			elementalControlMI.setVisible(false);
			powerFrameworksMenu.setVisible(false);
		}
		if (HeroDesigner.getActiveTemplate().is6E()) {
			elementalControlMI.setVisible(false);
		}
		if (HeroDesigner.getInstance().getPrefs().getSources().contains(
				"Hero System Fifth Edition Rule Book")) {
			vppMI.setVisible(true);
		} else {
			vppMI.setVisible(false);
		}
	}
}